<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

class CheckFeatureFlags extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'features:check';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Check the status of all feature flags';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Feature Flags Status:');
        $this->info('=====================');
        
        $features = [
            'use_normalized_approvals' => 'Normalized Approvals',
            'use_normalized_disbursements' => 'Normalized Disbursements', 
            'use_swift_code_mapping' => 'SWIFT Code Mapping',
            'use_improved_loan_controller' => 'Improved Loan Controller',
            'use_improved_disbursement' => 'Improved Disbursement',
            'use_improved_nmb_service' => 'Improved NMB Service',
        ];
        
        foreach ($features as $key => $name) {
            $status = config("features.{$key}", false);
            $statusText = $status ? '✅ ENABLED' : '❌ DISABLED';
            $this->line("{$name}: {$statusText}");
        }
        
        $this->info('');
        $this->info('To enable a feature, add it to your .env file:');
        $this->info('Example: USE_NORMALIZED_APPROVALS=true');
        
        return Command::SUCCESS;
    }
}